implementation module windowaccess


//	Object I/O library, version 1.1

//	Access operations to Window(State)Handle(s).


import StdInt, StdList, StdMisc
import oswindow
import commondef, devicesystemstate, windowhandle


windowaccessFatalError :: String String -> .x
windowaccessFatalError function error
	= FatalError function "windowaccess" error


//	Dummy values for window handles.

dummyWindowHandles :: WindowHandles .ps
dummyWindowHandles
	= {	whsWindows		= undef
//	  ,	whsCursorInfo	= undef
	  ,	whsIds			= undef
	  ,	whsNrWindowBound= undef
	  ,	whsModal		= undef
	  }

dummyWindowStateHandle :: WindowStateHandle .ps
dummyWindowStateHandle
	= {	wshIds			= undef
	  ,	wshHandle		= undef
	  }

dummyWindowLSHandle :: WindowLSHandle .ls .ps
dummyWindowLSHandle
	= {	wlsState		= undef
	  ,	wlsHandle		= undef
	  }

dummyWindowHandle :: WindowHandle .ls .ps
dummyWindowHandle
	= {	whMode			= undef
	  ,	whKind			= undef
	  ,	whTitle			= undef
	  ,	whItemNrs		= undef
	  ,	whKeyFocus		= undef
	  ,	whWindowInfo	= undef
	  ,	whItems			= undef
	  ,	whShow			= undef
	  ,	whSelect		= undef
	  ,	whAtts			= undef
	  ,	whDefaultId		= undef
	  ,	whCancelId		= undef
	  ,	whSize			= undef
	  }


//	Access to the additional WItemInfo field of a WItemHandle (partial functions!).

getWItemRadioInfo :: !(WItemInfo .ls .ps) -> RadioInfo (.ls,.ps)
getWItemRadioInfo (RadioInfo info) = info

getWItemCheckInfo :: !(WItemInfo .ls .ps) -> CheckInfo (.ls,.ps)
getWItemCheckInfo (CheckInfo info) = info

getWItemPopUpInfo :: !(WItemInfo .ls .ps) -> PopUpInfo (.ls,.ps)
getWItemPopUpInfo (PopUpInfo info) = info

getWItemSliderInfo :: !(WItemInfo .ls .ps) -> SliderInfo (.ls,.ps)
getWItemSliderInfo (SliderInfo info) = info

getWItemTextInfo :: !(WItemInfo .ls .ps) -> TextInfo
getWItemTextInfo (TextInfo info) = info

getWItemEditInfo :: !(WItemInfo .ls .ps) -> EditInfo
getWItemEditInfo (EditInfo info) = info

getWItemButtonInfo :: !(WItemInfo .ls .ps) -> ButtonInfo
getWItemButtonInfo (ButtonInfo info) = info

getWItemCustomButtonInfo :: !(WItemInfo .ls .ps) -> CustomButtonInfo
getWItemCustomButtonInfo (CustomButtonInfo info) = info

getWItemCustomInfo :: !(WItemInfo .ls .ps) -> CustomInfo
getWItemCustomInfo (CustomInfo info) = info

getWItemCompoundInfo :: !(WItemInfo .ls .ps) -> CompoundInfo
getWItemCompoundInfo (CompoundInfo info) = info

getWItemReceiverInfo :: !(WItemInfo .ls .ps) -> ReceiverHandle .ls .ps
getWItemReceiverInfo (ReceiverInfo info) = info


//	For internal identification of windows/dialogs Id and OSWindowPtr (Integer) can be used.

::	WID							// Identify a window/dialog either
	=	ById  !Id				// by its Id, or
	|	ByPtr !OSWindowPtr		// by its OSWindowPtr

class toWID x :: !x -> WID

instance toWID Id
where
	toWID :: !Id -> WID
	toWID id = ById id
instance toWID Int
where
	toWID :: !Int -> WID
	toWID wPtr = ByPtr wPtr

WIDbyId :: !WID -> Bool
WIDbyId (ById _)	= True
WIDbyId _			= False

WIDbyPtr :: !WID -> Bool
WIDbyPtr (ByPtr _)	= True
WIDbyPtr _			= False

WIDgetId :: !WID -> Id
WIDgetId (ById id)	= id

WIDgetPtr :: !WID -> OSWindowPtr
WIDgetPtr (ByPtr ptr) = ptr

//identifyWindowIds :: !WID !WIDS -> Bool
identifyWIDS :: !WID !WIDS -> Bool
identifyWIDS (ById  id)  {wId}  = id==wId
identifyWIDS (ByPtr ptr) {wPtr} = ptr==wPtr

identifyMaybeId :: !Id !(Maybe Id) -> Bool
identifyMaybeId id (Just id`) = id==id`
identifyMaybeId _ _ = False


//	Access operations on WindowStateHandles:

getWindowStateHandleWIDS :: !(WindowStateHandle .ps) -> (!WIDS,!WindowStateHandle .ps)
getWindowStateHandleWIDS wsH=:{wshIds}
	= (wshIds,wsH)

getWindowStateHandleWindowMode :: !(WindowStateHandle .ps) -> (!WindowMode,!WindowStateHandle .ps)
getWindowStateHandleWindowMode wsH=:{wshHandle=Just {wlsHandle={whMode}}}
	= (whMode,wsH)

getWindowStateHandleWindowKind :: !(WindowStateHandle .ps) -> (!WindowKind,!WindowStateHandle .ps)
getWindowStateHandleWindowKind wsH=:{wshHandle=Just {wlsHandle={whKind}}}
	= (whKind,wsH)

getWindowStateHandleWindowTitle :: !(WindowStateHandle .ps) -> (!Title,!WindowStateHandle .ps)
getWindowStateHandleWindowTitle wsH=:{wshHandle=Just {wlsHandle={whTitle}}}
	= (whTitle,wsH)

getWindowStateHandleItemNrs :: !(WindowStateHandle .ps) -> (![Int],!WindowStateHandle .ps)
getWindowStateHandleItemNrs wsH=:{wshHandle=Just {wlsHandle={whItemNrs}}}
	= (whItemNrs,wsH)

getWindowStateHandleKeyFocus :: !(WindowStateHandle .ps) -> (!KeyFocus,!WindowStateHandle .ps)
getWindowStateHandleKeyFocus wsH=:{wshHandle=Just {wlsHandle={whKeyFocus}}}
	= (whKeyFocus,wsH)

getWindowStateHandleWindowInfo :: !(WindowStateHandle .ps) -> (!Maybe WindowInfo,!WindowStateHandle .ps)
getWindowStateHandleWindowInfo wsH=:{wshHandle=Just {wlsHandle={whWindowInfo}}}
	= (whWindowInfo,wsH)

getWindowStateHandleShow :: !(WindowStateHandle .ps) -> (!Bool,!WindowStateHandle .ps)
getWindowStateHandleShow wsH=:{wshHandle=Just {wlsHandle={whShow}}}
	= (whShow,wsH)

getWindowStateHandleSelect :: !(WindowStateHandle .ps) -> (!Bool,!WindowStateHandle .ps)
getWindowStateHandleSelect wsH=:{wshHandle=Just {wlsHandle={whSelect}}}
	= (whSelect,wsH)

getWindowStateHandleDefaultId :: !(WindowStateHandle .ps) -> (!Maybe Id,!WindowStateHandle .ps)
getWindowStateHandleDefaultId wsH=:{wshHandle=Just {wlsHandle={whDefaultId}}}
	= (whDefaultId,wsH)

getWindowStateHandleCancelId :: !(WindowStateHandle .ps) -> (!Maybe Id,!WindowStateHandle .ps)
getWindowStateHandleCancelId wsH=:{wshHandle=Just {wlsHandle={whCancelId}}}
	= (whCancelId,wsH)

getWindowStateHandleSize :: !(WindowStateHandle .ps) -> (!Size,!WindowStateHandle .ps)
getWindowStateHandleSize wsH=:{wshHandle=Just {wlsHandle={whSize}}}
	= (whSize,wsH)

isWindowStateHandlePlaceHolder :: !(WindowStateHandle .ps) -> (!Bool,!WindowStateHandle .ps)
isWindowStateHandlePlaceHolder wsH=:{wshHandle=Nothing}
	= (True,wsH)
isWindowStateHandlePlaceHolder wsH
	= (False,wsH)

identifyWindowStateHandle :: !WID !(WindowStateHandle .ps) -> (!Bool,!WindowStateHandle .ps)
identifyWindowStateHandle wid wsH
	# (wids,wsH)	= getWindowStateHandleWIDS wsH
	= (identifyWIDS wid wids,wsH)

setWindowStateHandleWindowTitle :: !Title !(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleWindowTitle title wsH=:{wshHandle=Just wlsH=:{wlsHandle=wH}}
	= {wsH & wshHandle=Just {wlsH & wlsHandle={wH & whTitle=title}}}

setWindowStateHandleItemNrs :: ![Int] !(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleItemNrs itemNrs wsH=:{wshHandle=Just wlsH=:{wlsHandle=wH}}
	= {wsH & wshHandle=Just {wlsH & wlsHandle={wH & whItemNrs=itemNrs}}}

setWindowStateHandleKeyFocus :: !KeyFocus !(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleKeyFocus keyFocus wsH=:{wshHandle=Just wlsH=:{wlsHandle=wH}}
	= {wsH & wshHandle=Just {wlsH & wlsHandle={wH & whKeyFocus=keyFocus}}}

setWindowStateHandleWindowInfo :: !(Maybe WindowInfo) !(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleWindowInfo windowInfo wsH=:{wshHandle=Just wlsH=:{wlsHandle=wH}}
	= {wsH & wshHandle=Just {wlsH & wlsHandle={wH & whWindowInfo=windowInfo}}}

setWindowStateHandleShow :: !Bool !(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleShow show wsH=:{wshHandle=Just wlsH=:{wlsHandle=wH}}
	= {wsH & wshHandle=Just {wlsH & wlsHandle={wH & whShow=show}}}

setWindowStateHandleSelect :: !Bool !(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleSelect select wsH=:{wshHandle=Just wlsH=:{wlsHandle=wH}}
	= {wsH & wshHandle=Just {wlsH & wlsHandle={wH & whSelect=select}}}

setWindowStateHandleDefaultId :: !(Maybe Id) !(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleDefaultId defaultId wsH=:{wshHandle=Just wlsH=:{wlsHandle=wH}}
	= {wsH & wshHandle=Just {wlsH & wlsHandle={wH & whDefaultId=defaultId}}}

setWindowStateHandleCancelId :: !(Maybe Id) !(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleCancelId cancelId wsH=:{wshHandle=Just wlsH=:{wlsHandle=wH}}
	= {wsH & wshHandle=Just {wlsH & wlsHandle={wH & whCancelId=cancelId}}}

setWindowStateHandleSize :: !Size !(WindowStateHandle .ps) -> WindowStateHandle .ps
setWindowStateHandleSize size wsH=:{wshHandle=Just wlsH=:{wlsHandle=wH}}
	= {wsH & wshHandle=Just {wlsH & wlsHandle={wH & whSize=size}}}


//	Search, get, and set WindowStateHandles.

getWindowHandlesActiveWindow :: !(WindowHandles .ps) -> (!Bool,WIDS,!WindowHandles .ps)
getWindowHandlesActiveWindow wHs=:{whsWindows=[{wshIds}:_]}
	= (True,wshIds,wHs)
getWindowHandlesActiveWindow wHs
	= (False,undef,wHs)

hasWindowHandlesWindow :: !WID !(WindowHandles .ps) -> (!Bool,!WindowHandles .ps)
hasWindowHandlesWindow wid wHs=:{whsWindows}
	# (found,windows)	= haswindow wid whsWindows
	= (found,{wHs & whsWindows=windows})
where
	haswindow :: !WID ![WindowStateHandle .ps] -> (!Bool,![WindowStateHandle .ps])
	haswindow wid [wsH:wsHs]
		# (wIds,wsH)	= getWindowStateHandleWIDS wsH
		| identifyWIDS wid wIds
		= (True, [wsH:wsHs])
		# (found,wsHs)	= haswindow wid wsHs
		= (found,[wsH:wsHs])
	haswindow _ _
		= (False,[])

getWindowHandlesWindow :: !WID !(WindowHandles .ps) -> (!Bool,!WindowStateHandle .ps,!WindowHandles .ps)
getWindowHandlesWindow wid wHs=:{whsWindows}
	# (ok,wsH,wsHs)	= getwindow wid whsWindows
	= (ok,wsH,{wHs & whsWindows=wsHs})
where
	getwindow :: !WID ![WindowStateHandle .ps] -> (!Bool,!WindowStateHandle .ps,![WindowStateHandle .ps])
	getwindow wid [wsH:wsHs]
		# (wIds,wsH)	= getWindowStateHandleWIDS wsH
		| identifyWIDS wid wIds
		= (True, wsH, [{wshIds=wIds,wshHandle=Nothing}:wsHs])
		# (found,wsH`,wsHs) = getwindow wid wsHs
		= (found,wsH`,[wsH:wsHs])
	getwindow _ _
		= (False,dummyWindowStateHandle,[])

removeWindowHandlesWindow :: !WID !(WindowHandles .ps) -> (!Bool,!WindowStateHandle .ps,!WindowHandles .ps)
removeWindowHandlesWindow wid wHs=:{whsWindows}
	# (ok,wsH,wsHs)	= URemove (identifyWindowStateHandle wid) dummyWindowStateHandle whsWindows
	= (ok,wsH,{wHs & whsWindows=wsHs})
where
	identifyWindowStateHandle :: !WID !(WindowStateHandle .ps) -> (!Bool,!WindowStateHandle .ps)
	identifyWindowStateHandle wid wsH
		# (windowIds,wsH)	= getWindowStateHandleWIDS wsH
		= (identifyWIDS wid windowIds,wsH)

setWindowHandlesWindow :: !(WindowStateHandle .ps) !(WindowHandles .ps) -> WindowHandles .ps
setWindowHandlesWindow wsH wHs=:{whsWindows}
	# (isPlaceHolder,wsH)	= isWindowStateHandlePlaceHolder wsH
	| isPlaceHolder
	= windowaccessFatalError "setWindowHandlesWindow" "WindowStateHandle argument should not be a place holder"
	# (wIds,wsH)			= getWindowStateHandleWIDS wsH
	#! wsHs					= setwindow wIds wsH whsWindows		// PA: strictness added
	= {wHs & whsWindows=wsHs}
where
	setwindow :: !WIDS !(WindowStateHandle .ps) ![WindowStateHandle .ps] -> [WindowStateHandle .ps]
	setwindow wids wsH [wsH`:wsHs]
		# (wids`,wsH`)		= getWindowStateHandleWIDS wsH`
		| wids<>wids`
			#! wsHs			= setwindow wids wsH wsHs
			= [wsH`:wsHs]
		# (isPlaceHolder,_)	= isWindowStateHandlePlaceHolder wsH`
		| isPlaceHolder
			= [wsH:wsHs]
			= windowaccessFatalError "setWindowHandlesWindow" "place holder expected instead of WindowStateHandle"
	setwindow _ _ _
		= windowaccessFatalError "setWindowHandlesWindow" "place holder not found"

addWindowHandlesWindow :: !Index !(WindowStateHandle .ps) !(WindowHandles .ps) -> WindowHandles .ps
addWindowHandlesWindow index wsH wHs=:{whsWindows}
	#! wsHs	= insert (max 0 index) wsH whsWindows
	= {wHs & whsWindows=wsHs}
where
	insert :: !Index !.x ![.x] -> [.x]
	insert 0 x ys
		= [x:ys]
	insert i x [y:ys]
		#! ys = insert (i-1) x ys
		= [y:ys]
	insert _ x _
		= [x]


/*	disableWindowSystem disables all current windows.
	The return WIDS is the WIDS of the topmost active modal dialogue, if present. 
*/
disableWindowSystem :: !(WindowHandles .ps) !*OSToolbox -> (!(!Maybe WIDS,!WindowHandles .ps),!*OSToolbox)
disableWindowSystem windows=:{whsModal,whsWindows} tb
	| not whsModal
		# (wHs,tb)	= StateMap disablewindow whsWindows tb
		= ((Nothing,{windows & whsModal=True,whsWindows=wHs}),tb)
	# (ok,wids,windows)	= getWindowHandlesActiveWindow windows
	| not ok
		= windowaccessFatalError "disableWindowSystem" "no active window found"
	// otherwise
		= ((Just wids,windows),OSdisableWindow wids.wPtr (False,False) True tb)
where
	disablewindow :: !(WindowStateHandle .ps) !*OSToolbox -> (!WindowStateHandle .ps,!*OSToolbox)
	disablewindow wsH tb
		# (wids,wsH)			= getWindowStateHandleWIDS wsH
		# (maybeWindowInfo,wsH)	= getWindowStateHandleWindowInfo wsH
		# scrollInfo			= case maybeWindowInfo of
									Nothing		-> (False,False)
									Just info	-> (isJust info.windowHScroll,isJust info.windowVScroll)
		= (wsH,OSdisableWindow wids.wPtr scrollInfo True tb)

/*	enableWindowSystem Nothing re-enables all current windows.
	enableWindowSystem (Just wids) re-enables the modal dialogue indicated by wids.
*/
enableWindowSystem :: !(Maybe WIDS) !(WindowHandles .ps) !*OSToolbox -> (!WindowHandles .ps,!*OSToolbox)
enableWindowSystem Nothing windows=:{whsWindows} tb
	# (wHs,tb)	= StateMap enablewindow whsWindows tb
	= ({windows & whsModal=False,whsWindows=wHs},tb)
where
	enablewindow :: !(WindowStateHandle .ps) !*OSToolbox -> (!WindowStateHandle .ps,!*OSToolbox)
	enablewindow wsH tb
		# (whSelect,wsH)		= getWindowStateHandleSelect wsH
		| not whSelect
		= (wsH,tb)
		# (wids,wsH)			= getWindowStateHandleWIDS wsH
		# (maybeWindowInfo,wsH)	= getWindowStateHandleWindowInfo wsH
		  scrollInfo			= case maybeWindowInfo of
		  							Nothing		-> (False,False)
		  							Just info	-> (isJust info.windowHScroll,isJust info.windowVScroll)
		= (wsH,OSenableWindow wids.wPtr scrollInfo True tb)
enableWindowSystem (Just wids) windows tb
	= (windows,OSenableWindow wids.wPtr (False,False) True tb)


//	Get the WindowHandles from a WindowSystemState.
WindowSystemStateGetWindowHandles :: !(DeviceSystemState .ps) -> WindowHandles .ps
WindowSystemStateGetWindowHandles (WindowSystemState wHs)
	= wHs
WindowSystemStateGetWindowHandles _
	= windowaccessFatalError "WindowSystemStateGetWindowHandles" "argument is no WindowSystemState"
